"use client";

import { useEffect, useState } from "react";
import { useLanguage } from "@/contexts/LanguageContext";
import Button from '@/components/ui/Button';
import wordpressAPI from "@/lib/wordpress";

export default function AboutPage() {
    const { language } = useLanguage();
    const [page, setPage] = useState<any | null>(null);

    useEffect(() => {
        const fetchData = async () => {
            const data = await wordpressAPI.getPageBySlug("about", language);
            setPage(data);
        };
        fetchData();
    }, [language]);

    if (!page) return null; // ❌ no loading, just render nothing till ready

    return (
        <section className="about-page">
            {/* ✅ Hero Section */}
            <div className="hero bg-gray-100 py-16 text-center space-y-4">
                <h1 className="text-4xl font-bold mb-4">{page.hero_title}</h1>
                <p className="text-lg max-w-2xl mx-auto">{page.hero_description}</p>
                {page.hero_button_text && (
                    <Button href={page.hero_button_url} variant="primary" size="md">
                        {page.hero_button_text}
                    </Button>
                )}
            </div>

            {/* ✅ About Us Section */}
            <div className="about-us py-16 text-center">
                <h2 className="text-3xl font-semibold mb-4">{page.about_title}</h2>
                <p className="text-lg max-w-3xl mx-auto">{page.about_description}</p>
            </div>
        </section>
    );
}
