import type { Metadata } from "next";
import localFont from "next/font/local";
import "./globals.css";
import Header from "@/components/Header";
import Breadcrumb from '@/components/header/Breadcrumb';
import Footer from "@/components/Footer";
import { LanguageProvider } from "@/contexts/LanguageContext";
import PageTransition from "@/components/PageTransition";
import HtmlWrapper from "@/components/HtmlWrapper";

const interLocal = localFont({
  src: [
    { path: "../public/fonts/inter/regular.woff2", weight: "400", style: "normal" },
    { path: "../public/fonts/inter/medium.woff2", weight: "500", style: "normal" },
    { path: "../public/fonts/inter/semibold.woff2", weight: "600", style: "normal" },
    { path: "../public/fonts/inter/bold.woff2", weight: "700", style: "normal" },
  ],
  variable: "--font-inter",
});

const somarsansLocal = localFont({
  src: [
    { path: "../public/fonts/somarsans/regular.woff2", weight: "400", style: "normal" },
    { path: "../public/fonts/somarsans/medium.woff2", weight: "500", style: "normal" },
    { path: "../public/fonts/somarsans/semibold.woff2", weight: "600", style: "normal" },
    { path: "../public/fonts/somarsans/bold.woff2", weight: "700", style: "normal" },
  ],
  variable: "--font-somarsans",
});

export const metadata: Metadata = {
  title: "Elagami — Modern WordPress + Next.js Theme",
  description: "A custom WordPress-powered frontend built with Next.js, Tailwind CSS, and full multilingual support.",
};

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html
      data-scroll-behavior="smooth"
      lang="en"
      dir="ltr"
      className={`${interLocal.variable} ${somarsansLocal.variable} font-ltr`}
    >
      <LanguageProvider>
        <HtmlWrapper>
          <Header />
          <Breadcrumb />
          <main className="site-content flex-1">
            <div id="primary">
              <PageTransition>{children}</PageTransition>
            </div>
          </main>
          <Footer />
        </HtmlWrapper>
      </LanguageProvider>
    </html>
  );
}
