"use client";

import Link from "next/link";

interface ButtonProps
    extends React.ButtonHTMLAttributes<HTMLButtonElement> {
    variant?: "default" | "primary" | "secondary" | "outline" | "danger";
    size?: "sm" | "md" | "lg";
    href?: string;
}

export default function Button({
    children,
    className,
    variant = "default",
    size = "md",
    href,
    ...props
}: ButtonProps) {
    const base =
        "inline-flex items-center justify-center font-medium rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 transition-colors";

    const variants: Record<string, string> = {
        default:
            "bg-gray-200 text-gray-800 hover:bg-gray-300 focus:ring-gray-400",
        primary:
            "bg-primary-600 text-white hover:bg-primary-700 focus:ring-primary-500",
        secondary:
            "bg-gray-600 text-white hover:bg-gray-700 focus:ring-gray-500",
        outline:
            "border border-gray-300 text-gray-700 hover:bg-gray-50 focus:ring-primary-500",
        danger:
            "bg-red-600 text-white hover:bg-red-700 focus:ring-red-500",
    };

    const sizes: Record<string, string> = {
        sm: "px-3 py-1 text-sm",
        md: "px-4 py-2 text-sm",
        lg: "px-6 py-3 text-base",
    };

    const classes = [base, variants[variant], sizes[size], className]
        .filter(Boolean)
        .join(" ");

    if (href) {
        return (
            <Link href={href} className={classes}>
                {children}
            </Link>
        );
    }

    return (
        <button className={classes} {...props}>
            {children}
        </button>
    );
}
